/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util.cron.terms;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.util.cron.CronBuilder;
import com.elitescloud.boot.util.cron.constant.CronWeek;
import com.elitescloud.boot.util.cron.terms.AbstractCronTerm;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class WeekCronTerm
extends AbstractCronTerm {
    private Boolean every;
    private Boolean notAssign;
    private Set<CronWeek> specificValues;
    private AbstractCronTerm.RangeValue rangeValue;
    private CronWeek lastWeek;
    private Boolean lastDay;
    private Integer lastDayValue;
    private AbstractCronTerm.TwoDigitValue whichWeek;

    public WeekCronTerm(CronBuilder cronBuilder) {
        super(cronBuilder);
    }

    public WeekCronTerm every() {
        this.every = true;
        return this;
    }

    public WeekCronTerm notAssign() {
        this.notAssign = true;
        return this;
    }

    public WeekCronTerm of(CronWeek ... weeks) {
        if (weeks == null || weeks.length == 0) {
            return this;
        }
        if (this.specificValues == null) {
            this.specificValues = new HashSet<CronWeek>(60);
        }
        this.specificValues.addAll(Arrays.asList(weeks));
        return this;
    }

    public WeekCronTerm of(List<CronWeek> weeks) {
        if (weeks == null || weeks.isEmpty()) {
            return this;
        }
        if (this.specificValues == null) {
            this.specificValues = new HashSet<CronWeek>(60);
        }
        this.specificValues.addAll(weeks);
        return this;
    }

    public WeekCronTerm ofRange(CronWeek start, CronWeek end) {
        Assert.notNull((Object)((Object)start), (String)"\u5468\u7684\u5f00\u59cb\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)((Object)end), (String)"\u5468\u7684\u7ed3\u675f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.rangeValue = new AbstractCronTerm.RangeValue(start.getValue(), end.getValue());
        return this;
    }

    public WeekCronTerm ofLastWeek(CronWeek week) {
        this.lastWeek = week;
        return this;
    }

    public WeekCronTerm ofLastDay() {
        this.lastDay = true;
        return this;
    }

    public WeekCronTerm ofLastDay(int lastDay) {
        this.lastDayValue = lastDay;
        return this;
    }

    public WeekCronTerm ofWhichWeek(int whichWeek, CronWeek week) {
        this.whichWeek = new AbstractCronTerm.TwoDigitValue(whichWeek, week.getValue());
        return this;
    }

    @Override
    public String buildExpression() {
        if (Boolean.TRUE.equals(this.every)) {
            return "*";
        }
        if (Boolean.TRUE.equals(this.notAssign)) {
            return "?";
        }
        if (CollUtil.isNotEmpty(this.specificValues)) {
            return this.specificValues.stream().map(CronWeek::getValue).peek(this::validateValue).sorted().map(String::valueOf).collect(Collectors.joining(","));
        }
        if (this.rangeValue != null) {
            this.validateValue(this.rangeValue.getStart());
            this.validateValue(this.rangeValue.getEnd());
            if (this.rangeValue.getStart() > this.rangeValue.getEnd()) {
                throw new IllegalArgumentException("\u5468\u7684\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u622a\u6b62\u65f6\u95f4");
            }
            return this.rangeValue.getStart() + "-" + this.rangeValue.getEnd();
        }
        if (this.lastWeek != null) {
            this.validateValue(this.lastWeek.getValue());
            return this.lastWeek.getValue() + "L";
        }
        if (Boolean.TRUE.equals(this.lastDay)) {
            return "L";
        }
        if (this.lastDayValue != null) {
            return "L-" + this.lastDayValue;
        }
        if (this.whichWeek != null) {
            Assert.isTrue((this.whichWeek.getDigit() >= 1 ? 1 : 0) != 0, (String)"\u7b2c\u51e0\u5468\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e1", (Object[])new Object[0]);
            this.validateValue(this.whichWeek.getValue());
            return this.whichWeek.getDigit() + "#" + this.whichWeek.getValue();
        }
        return "?";
    }

    private void validateValue(int value) {
        Assert.isTrue((value >= 1 && value <= 7 ? 1 : 0) != 0, (String)"\u5468\u7684\u503c\u8303\u56f41-7", (Object[])new Object[0]);
    }
}

