/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util.cron;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.util.cron.terms.DayCronTerm;
import com.elitescloud.boot.util.cron.terms.HourCronTerm;
import com.elitescloud.boot.util.cron.terms.MinuteCronTerm;
import com.elitescloud.boot.util.cron.terms.MonthCronTerm;
import com.elitescloud.boot.util.cron.terms.SecondCronTerm;
import com.elitescloud.boot.util.cron.terms.WeekCronTerm;
import com.elitescloud.boot.util.cron.terms.YearCronTerm;
import java.util.StringJoiner;

public class CronBuilder {
    private final SecondCronTerm secondCronTerm = new SecondCronTerm(this);
    private final MinuteCronTerm minuteCronTerm = new MinuteCronTerm(this);
    private final HourCronTerm hourCronTerm = new HourCronTerm(this);
    private final DayCronTerm dayCronTerm = new DayCronTerm(this);
    private final MonthCronTerm monthCronTerm = new MonthCronTerm(this);
    private final WeekCronTerm weekCronTerm = new WeekCronTerm(this);
    private final YearCronTerm yearCronTerm = new YearCronTerm(this);

    private CronBuilder() {
    }

    public static CronBuilder newBuilder() {
        return new CronBuilder();
    }

    public SecondCronTerm second() {
        return this.secondCronTerm;
    }

    public MinuteCronTerm minute() {
        return this.minuteCronTerm;
    }

    public HourCronTerm hour() {
        return this.hourCronTerm;
    }

    public DayCronTerm day() {
        return this.dayCronTerm;
    }

    public MonthCronTerm month() {
        return this.monthCronTerm;
    }

    public WeekCronTerm week() {
        return this.weekCronTerm;
    }

    public YearCronTerm year() {
        return this.yearCronTerm;
    }

    public String build() {
        StringJoiner joiner = new StringJoiner(" ");
        try {
            joiner.add(this.secondCronTerm.buildExpression());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u79d2\u8bbe\u7f6e\u6709\u8bef, " + e.getMessage(), e);
        }
        try {
            joiner.add(this.minuteCronTerm.buildExpression());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5206\u949f\u8bbe\u7f6e\u6709\u8bef, " + e.getMessage(), e);
        }
        try {
            joiner.add(this.hourCronTerm.buildExpression());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5c0f\u65f6\u8bbe\u7f6e\u6709\u8bef, " + e.getMessage(), e);
        }
        String dayCron = null;
        try {
            dayCron = this.dayCronTerm.buildExpression();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u65e5\u8bbe\u7f6e\u6709\u8bef, " + e.getMessage(), e);
        }
        String monthCron = null;
        try {
            monthCron = this.monthCronTerm.buildExpression();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u6708\u8bbe\u7f6e\u6709\u8bef, " + e.getMessage(), e);
        }
        String weekCron = null;
        try {
            weekCron = this.weekCronTerm.buildExpression();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5468\u8bbe\u7f6e\u6709\u8bef, " + e.getMessage(), e);
        }
        if ("*".equals(dayCron)) {
            if (!"?".equals(weekCron)) {
                dayCron = "?";
            }
        } else if (!"?".equals(dayCron)) {
            Assert.isTrue((boolean)"?".equals(weekCron), (String)"\u65e5\u548c\u5468\u4e0d\u80fd\u540c\u65f6\u8bbe\u7f6e", (Object[])new Object[0]);
        }
        joiner.add(dayCron);
        joiner.add(monthCron);
        joiner.add(weekCron);
        try {
            String year = this.year().buildExpression();
            if (!"?".equals(year)) {
                joiner.add(year);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5e74\u8bbe\u7f6e\u6709\u8bef, " + e.getMessage(), e);
        }
        return joiner.toString();
    }
}

