/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.common.translate.translator;

import com.elitescloud.boot.common.translate.TranslatorCustomizer;
import com.elitescloud.boot.util.BeanWrapperUtil;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTranslatorCustomizer
implements TranslatorCustomizer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTranslatorCustomizer.class);

    protected void executeTranslate(@NotNull Object data, @NotNull Function<BeanWrapperUtil.CustomField, String> targetFieldSupplier, @NotNull BiFunction<BeanWrapperUtil.CustomField, Object, Object> targetValueSupplier) {
        this.executeTranslate(data, targetFieldSupplier, targetValueSupplier, false);
    }

    protected void executeTranslate(@NotNull Object data, @NotNull Function<BeanWrapperUtil.CustomField, String> targetFieldSupplier, @NotNull BiFunction<BeanWrapperUtil.CustomField, Object, Object> targetValueSupplier, boolean reversal) {
        Map fieldMap = BeanWrapperUtil.getFields(data).stream().collect(Collectors.toMap(t -> t.getField().getName(), Function.identity(), (t1, t2) -> t1));
        if (fieldMap.isEmpty()) {
            return;
        }
        String targetFieldName = null;
        BeanWrapperUtil.CustomField targetField = null;
        DataAccessHelper dataAccessHelper = new DataAccessHelper(data);
        for (Map.Entry entry : fieldMap.entrySet()) {
            Object result;
            targetFieldName = targetFieldSupplier.apply((BeanWrapperUtil.CustomField)entry.getValue());
            if (targetFieldName == null) continue;
            targetField = (BeanWrapperUtil.CustomField)fieldMap.get(targetFieldName);
            if (targetField == null) {
                logger.warn("\u7ffb\u8bd1\u5ffd\u7565\uff0c\u672a\u83b7\u53d6\u5230{}\u7684\u7ffb\u8bd1\u5b57\u6bb5\uff1a{}", (Object)((BeanWrapperUtil.CustomField)entry.getValue()).toString(), (Object)targetFieldName);
                continue;
            }
            Object value = null;
            try {
                value = dataAccessHelper.readProperty(reversal ? targetField : (BeanWrapperUtil.CustomField)entry.getValue());
            }
            catch (Exception e) {
                logger.warn("\u7ffb\u8bd1\u5ffd\u7565\uff0c\u83b7\u53d6{}\u7684\u503c\u5f02\u5e38\uff1a", (Object)(reversal ? targetField : (BeanWrapperUtil.CustomField)entry.getValue()).toString(), (Object)e);
                continue;
            }
            if (ObjUtil.isEmpty(value) || ObjUtil.isEmpty(result = targetValueSupplier.apply((BeanWrapperUtil.CustomField)entry.getValue(), value))) continue;
            try {
                dataAccessHelper.setProperty(reversal ? (BeanWrapperUtil.CustomField)entry.getValue() : targetField, result);
            }
            catch (Exception e) {
                logger.error("\u7ffb\u8bd1\u5ffd\u7565\uff0c\u5411{}\u5199\u5165\u7ffb\u8bd1\u7ed3\u679c\u5f02\u5e38\uff1a", reversal ? entry.getValue() : targetField, (Object)e);
            }
        }
    }

    protected String cacheKeyPrefix(SysTenantDTO tenant) {
        return tenant == null ? "default_" : "tenant_" + tenant.getTenantCode() + "_";
    }

    protected static class DataAccessHelper {
        private final Object data;

        public DataAccessHelper(Object data) {
            this.data = data;
        }

        public Object readProperty(@NotNull BeanWrapperUtil.CustomField customField) throws Exception {
            return this.readProperty(customField, false);
        }

        public Object readProperty(@NotNull BeanWrapperUtil.CustomField customField, boolean required) throws Exception {
            if (customField.getReadMethod() == null) {
                if (!required) {
                    return null;
                }
                throw new IllegalAccessException(customField.getField().getName() + "\u7f3a\u5c11get\u65b9\u6cd5");
            }
            return customField.getReadMethod().invoke(this.data, new Object[0]);
        }

        public void setProperty(@NotNull BeanWrapperUtil.CustomField customField, Object value) throws Exception {
            this.setProperty(customField, value, false);
        }

        public void setProperty(@NotNull BeanWrapperUtil.CustomField customField, Object value, boolean required) throws Exception {
            if (customField.getWriteMethod() == null) {
                if (!required) {
                    return;
                }
                throw new IllegalAccessException(customField.getField().getName() + "\u7f3a\u5c11set\u65b9\u6cd5");
            }
            customField.getWriteMethod().invoke(this.data, value);
        }
    }
}

