/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.common.base;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.BaseResult;
import com.elitescloud.cloudt.common.base.RpcResult;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.validation.constraints.NotNull;

public class ApiResult<T>
extends BaseResult<T, ApiResult<T>> {
    private static final long serialVersionUID = 7722914707623525357L;
    private static BiFunction<Integer, String, String> errorMsgConvert = (code, errorNo) -> "\u7cfb\u7edf\u51fa\u73b0\u5f02\u5e38,\u9519\u8bef\u53f7:{errorNo}, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
    private String errorMsg;

    public ApiResult() {
        super.setTime(new Date());
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public ApiResult<T> setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
        return this;
    }

    public ApiResult<T> errorMsg(String errorMsg) {
        return this.setErrorMsg(errorMsg);
    }

    public static <T> ApiResult<T> builder() {
        return new ApiResult<T>();
    }

    public ApiResult<T> build() {
        return this;
    }

    public RpcResult<T> toRpcResult() {
        return (RpcResult)((RpcResult)((RpcResult)((RpcResult)((RpcResult)((RpcResult)new RpcResult().code(this.getCode())).msg(this.getMsg())).success(this.isSuccess())).errorNo(this.getErrorNo())).data(this.getData())).time(this.getTime());
    }

    public T computeData() {
        if (super.isSuccess()) {
            String msg = this.getMsg();
            if (msg == null) {
                msg = this.getErrorMsg();
            }
            throw new BusinessException(msg);
        }
        return (T)this.getData();
    }

    public <R> ApiResult<R> map(@NotNull Function<T, R> mapper) {
        ApiResult<T> result = new ApiResult<T>();
        result.setErrorMsg(this.getErrorMsg());
        result.setCode(this.getCode());
        result.setMsg(this.getMsg());
        result.setSuccess(this.isSuccess());
        result.setErrorNo(this.getErrorNo());
        result.setData(mapper.apply(this.getData()));
        result.setTime(this.getTime());
        return result;
    }

    public static <T> ApiResult<T> result(boolean suc) {
        if (suc) {
            return ApiResult.ok();
        }
        return ApiResult.fail();
    }

    public static <T> ApiResult<T> result(ApiCode apiCode) {
        return ApiResult.result(apiCode, null);
    }

    public static <T> ApiResult<T> result(ApiCode apiCode, T data) {
        return ApiResult.result(apiCode, null, data);
    }

    public static <T> ApiResult<T> result(ApiCode apiCode, String msg, T data) {
        return ApiResult.result(apiCode, null, msg, null, data);
    }

    public static <T> ApiResult<T> result(ApiCode apiCode, String errorNo, String msg, String errorMsg, T data) {
        String msgFriendly;
        boolean success = apiCode == ApiCode.SUCCESS;
        String string = msgFriendly = ApiResult.isBlank(msg) ? apiCode.getMsgFriendly() : msg;
        if (ApiResult.isBlank(msgFriendly)) {
            msgFriendly = errorMsgConvert.apply(apiCode.getCode(), errorNo);
        }
        return ((ApiResult)((ApiResult)((ApiResult)((ApiResult)((ApiResult)ApiResult.builder().code(apiCode.getCode())).errorNo(errorNo)).msg(msgFriendly)).errorMsg(errorMsg).success(success)).data(data)).build();
    }

    public static <T> ApiResult<T> result(int code, String errorNo, String msg, String errorMsg, T data) {
        boolean success = code >= 200 && code < 300;
        String msgFriendly = ApiResult.isBlank(msg) ? errorMsgConvert.apply(code, errorNo) : msg;
        return ((ApiResult)((ApiResult)((ApiResult)((ApiResult)((ApiResult)ApiResult.builder().code(code)).errorNo(errorNo)).msg(msgFriendly)).errorMsg(errorMsg).data(data)).success(success)).build();
    }

    public static <T> ApiResult<T> ok() {
        return ApiResult.ok(null);
    }

    public static <T> ApiResult<T> ok(T data) {
        return ApiResult.result(ApiCode.SUCCESS, data);
    }

    public static <T> ApiResult<T> ok(T data, String msg) {
        return ApiResult.result(ApiCode.SUCCESS, msg, data);
    }

    public static <T> ApiResult<HashMap<String, T>> okMap(String key, T value) {
        HashMap<String, T> map = new HashMap<String, T>(4);
        map.put(key, value);
        return ApiResult.ok(map);
    }

    public static Map<String, Object> toMap(ApiResult<?> result) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("code", result.getCode());
        map.put("msg", result.getMsg());
        map.put("data", result.getData());
        map.put("success", result.isSuccess());
        map.put("time", result.getTime());
        return map;
    }

    public static <T> ApiResult<T> fail(ApiCode apiCode) {
        return ApiResult.fail(apiCode, null);
    }

    public static <T> ApiResult<T> fail(String msg) {
        return ApiResult.result(ApiCode.FAIL, msg, null);
    }

    public static <T> ApiResult<T> fail(int code, String msg) {
        return ApiResult.result(code, null, msg, null, null);
    }

    public static <T> ApiResult<T> fail(int code, String errorNo, T data, String msg) {
        return ApiResult.fail(code, errorNo, null, data, msg);
    }

    public static <T> ApiResult<T> fail(int code, String errorNo, String errorMsg, T data, String msg) {
        return ApiResult.result(code, errorNo, msg, errorMsg, data);
    }

    public static <T> ApiResult<T> fail(ApiCode apiCode, String msg) {
        if (ApiCode.SUCCESS == apiCode) {
            throw new IllegalArgumentException("\u5931\u8d25\u7ed3\u679c\u72b6\u6001\u7801\u4e0d\u80fd\u4e3a" + ApiCode.SUCCESS.getCode());
        }
        return ApiResult.result(apiCode, msg, null);
    }

    public static <T> ApiResult<T> fail(ApiCode apiCode, T data) {
        if (ApiCode.SUCCESS == apiCode) {
            throw new IllegalArgumentException("\u5931\u8d25\u7ed3\u679c\u72b6\u6001\u7801\u4e0d\u80fd\u4e3a" + ApiCode.SUCCESS.getCode());
        }
        return ApiResult.result(apiCode, data);
    }

    public static <T> ApiResult<T> fail(ApiCode apiCode, T data, String msg) {
        if (ApiCode.SUCCESS == apiCode) {
            throw new IllegalArgumentException("\u5931\u8d25\u7ed3\u679c\u72b6\u6001\u7801\u4e0d\u80fd\u4e3a" + ApiCode.SUCCESS.getCode());
        }
        return ApiResult.result(apiCode, msg, data);
    }

    public static <T> ApiResult<T> fail(ApiCode apiCode, String errorNo, String errorMsg, T data, String msg) {
        if (ApiCode.SUCCESS == apiCode) {
            throw new IllegalArgumentException("\u5931\u8d25\u7ed3\u679c\u72b6\u6001\u7801\u4e0d\u80fd\u4e3a" + ApiCode.SUCCESS.getCode());
        }
        return ApiResult.result(apiCode, errorNo, msg, errorMsg, data);
    }

    public static <T> ApiResult<HashMap<String, T>> fail(String key, T value) {
        HashMap<String, T> map = new HashMap<String, T>(1);
        map.put(key, value);
        return ApiResult.result(ApiCode.FAIL, map);
    }

    public static <T> ApiResult<T> fail() {
        return ApiResult.fail(ApiCode.FAIL);
    }

    public static <T> ApiResult<T> noData() {
        return ApiResult.fail(ApiCode.NOT_FOUND_DATA);
    }

    public static void setErrorMsgConvert(BiFunction<Integer, String, String> errorMsgConvert) {
        ApiResult.errorMsgConvert = errorMsgConvert;
    }

    private static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public String toString() {
        return "ApiResult{errorMsg='" + this.errorMsg + "', baseResult='" + super.toString() + "'}";
    }
}

