package com.elitescloud.boot.exception;

import com.elitescloud.cloudt.common.base.ApiCode;

import java.util.function.Supplier;

/**
 * 业务异常
 *
 * @author Michael Li
 * @date 2020/6/22
 */
public class BusinessException extends RuntimeException implements Supplier<BusinessException> {

    private static final long serialVersionUID = -2205002357611194846L;

    /**
     * 系统错误码
     */
    private final ApiCode apiCode;
    /**
     * 自定义错误码
     */
    private final Integer code;

    public BusinessException() {
        super();
        this.apiCode = null;
        this.code = null;
    }

    public BusinessException(String message) {
        super(message);
        this.apiCode = ApiCode.BUSINESS_EXCEPTION;
        this.code = null;
    }

    public BusinessException(ApiCode apiCode, String message) {
        super(message);
        this.apiCode = apiCode;
        this.code = null;
    }

    public BusinessException(ApiCode apiCode, String message, Throwable throwable) {
        super(message, throwable);
        this.apiCode = apiCode;
        this.code = null;
    }

    public BusinessException(Integer code, String message) {
        super(message);
        this.code = code;
        this.apiCode = null;
    }

    public BusinessException(Integer code, String message, Throwable throwable) {
        super(message, throwable);
        this.code = code;
        this.apiCode = null;
    }

    public BusinessException(String message, Throwable cause) {
        super(message, cause);
        this.apiCode = null;
        this.code = null;
    }

    public BusinessException(Throwable cause) {
        super(cause);
        this.apiCode = null;
        this.code = null;
    }

    public BusinessException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.apiCode = null;
        this.code = null;
    }

    @Override
    public BusinessException get() {
        return this;
    }

    public ApiCode getApiCode() {
        return apiCode;
    }

    public Integer getCode() {
        if (code == null && apiCode != null) {
            return apiCode.getCode();
        }
        return code;
    }
}
