package com.elitescloud.cloudt.common.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 注释
 * <p>
 * 可用于类和字段
 *
 * @author Michael Li
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD, ElementType.FIELD})
public @interface Comment {

    /**
     * 注释
     *
     * @return 注释
     */
    String value() default "";

    /**
     * 默认值
     * <p>
     * 字段有效
     *
     * @return 默认值
     */
    String defaultValue() default "";
}
