/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.exception;

import com.elitescloud.cloudt.common.base.ApiCode;
import java.util.function.Supplier;

public class BusinessException
extends RuntimeException
implements Supplier<BusinessException> {
    private static final long serialVersionUID = -2205002357611194846L;
    private final ApiCode apiCode;
    private final Integer code;

    public BusinessException() {
        this.apiCode = null;
        this.code = null;
    }

    public BusinessException(String message) {
        super(message);
        this.apiCode = ApiCode.BUSINESS_EXCEPTION;
        this.code = null;
    }

    public BusinessException(ApiCode apiCode, String message) {
        super(message);
        this.apiCode = apiCode;
        this.code = null;
    }

    public BusinessException(ApiCode apiCode, String message, Throwable throwable) {
        super(message, throwable);
        this.apiCode = apiCode;
        this.code = null;
    }

    public BusinessException(Integer code, String message) {
        super(message);
        this.code = code;
        this.apiCode = null;
    }

    public BusinessException(Integer code, String message, Throwable throwable) {
        super(message, throwable);
        this.code = code;
        this.apiCode = null;
    }

    public BusinessException(String message, Throwable cause) {
        super(message, cause);
        this.apiCode = null;
        this.code = null;
    }

    public BusinessException(Throwable cause) {
        super(cause);
        this.apiCode = null;
        this.code = null;
    }

    public BusinessException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.apiCode = null;
        this.code = null;
    }

    @Override
    public BusinessException get() {
        return this;
    }

    public ApiCode getApiCode() {
        return this.apiCode;
    }

    public Integer getCode() {
        if (this.code == null && this.apiCode != null) {
            return this.apiCode.getCode();
        }
        return this.code;
    }
}

