/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.common.base;

public enum ApiCode {
    SUCCESS(200, "\u64cd\u4f5c\u6210\u529f"),
    REDIRECT(302, "\u91cd\u5b9a\u5411"),
    BAD_REQUEST(400, "\u8bf7\u6c42\u6709\u8bef"),
    PARAMETER_PARSE_EXCEPTION(400001, "\u8bf7\u6c42\u53c2\u6570\u89e3\u6790\u5f02\u5e38"),
    PARAMETER_EXCEPTION(400002, "\u8bf7\u6c42\u53c2\u6570\u6821\u9a8c\u5f02\u5e38"),
    AUTHENTICATION_EXCEPTION(400003, "\u8ba4\u8bc1\u6388\u6743\u5f02\u5e38"),
    UNAUTHORIZED(401, "\u672a\u767b\u5f55\u6216token\u5df2\u7ecf\u8fc7\u671f"),
    NOT_PERMISSION(403, "\u6ca1\u6709\u6743\u9650"),
    NOT_FOUND(404, "\u4f60\u8bf7\u6c42\u7684\u8d44\u6e90\u4e0d\u5b58\u5728"),
    NOT_FOUND_DATA(404001, "\u6570\u636e\u4e0d\u5b58\u5728"),
    METHOD_NOT_SUPPORT(405, "\u8bf7\u6c42\u65b9\u5f0f\u4e0d\u652f\u6301"),
    NOT_ACCEPTABLE(406, "\u4e0d\u53ef\u8bbf\u95ee"),
    REQUEST_ENTITY_TOO_LARGE(413, "\u8bf7\u6c42\u4f53\u8fc7\u5927"),
    REQUEST_URL_TOO_LONG(414, "\u8bf7\u6c42\u8def\u5f84\u8fc7\u957f"),
    UNSUPPORTED_MEDIA_TYPE(415, "\u4e0d\u652f\u6301\u7684\u683c\u5f0f"),
    FAIL(500, "\u64cd\u4f5c\u5931\u8d25"),
    NOT_IMPLEMENTED(501, "\u672a\u5b9e\u73b0"),
    SYSTEM_EXCEPTION(500001, "\u7cfb\u7edf\u5f02\u5e38"),
    DATABASE_EXCEPTION(500002, "\u6570\u636e\u5e93\u8bbf\u95ee\u5f02\u5e38"),
    ELASTICSEARCH_EXCEPTION(500003, "Elasticsearch\u8bbf\u95ee\u5f02\u5e38"),
    SYSTEM_BUSY(503, "\u670d\u52a1\u5668\u6b63\u5fd9"),
    VISITOR_TOO_MANY(503001, "\u8bbf\u95ee\u7528\u6237\u8fc7\u591a"),
    THREAD_POOL_OVERFLOW(503002, "\u7ebf\u7a0b\u6c60\u6ea2\u51fa"),
    NO_PROVIDER(503003, "\u6ca1\u6709\u6709\u6548\u7684\u670d\u52a1\u63d0\u4f9b\u8005"),
    PROVIDER_EXCEPTION(503004, "\u670d\u52a1\u63d0\u4f9b\u8005\u5f02\u5e38"),
    GATEWAY_TIMEOUT(504, "\u7f51\u5173\u8d85\u65f6"),
    REQUEST_TIMEOUT(504001, "\u8bf7\u6c42\u8d85\u65f6"),
    BUSINESS_EXCEPTION(900, "\u4e1a\u52a1\u5904\u7406\u5f02\u5e38");

    private final int code;
    private final String msg;

    private ApiCode(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static ApiCode getApiCode(int code) {
        ApiCode[] ecs;
        for (ApiCode ec : ecs = ApiCode.values()) {
            if (ec.getCode() != code) continue;
            return ec;
        }
        return SUCCESS;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getMsgFriendly() {
        switch (this) {
            case SUCCESS: {
                return SUCCESS.getMsg();
            }
            case UNAUTHORIZED: {
                return "\u6682\u672a\u767b\u5f55\u6216\u8ba4\u8bc1\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55";
            }
            case NOT_PERMISSION: {
                return "\u6ca1\u6709\u6743\u9650";
            }
            case NOT_FOUND: 
            case NOT_FOUND_DATA: {
                return "\u6570\u636e\u4e0d\u5b58\u5728";
            }
            case PARAMETER_PARSE_EXCEPTION: {
                return "\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e";
            }
        }
        return null;
    }
}

