package com.elitescloud.cloudt.common.base;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 错误来源
 * <p>
 * <li>A：表示错误来源于用户 ，比如参数错误 ，用户安装版本过低 ，用户支付超时等问题；</li>
 * <li>B：表示错误来源于当前系统 ，往往是业务逻辑出错 ，或程序健壮性差等问题；</li>
 * <li>C：表示错误来源于第三方服务 ，比如 CDN </li>
 * <li>R：来源内部服务调用</li>
 * <li>D：暂未设置</li>
 *
 * @author nc
 * @date 2023-09-27
 */
public enum ErrorSource {

    /**
     * 错误描述
     */
    A("来源用户"),
    B("来源当前系统或业务逻辑"),
    C("来源于第三方服务"),
    R("来源内部服务调用"),
    D("未设置");

    private final String describe;

    ErrorSource(String describe) {
        this.describe = describe;
    }

    public String getDescribe() {
        return describe;
    }

    /**
     * 根据名称解析
     *
     * @param name 名称
     * @return 错误源
     */
    public static ErrorSource parse(String name) {
        return VALUE_MAP.get(name);
    }

    private static final Map<String, ErrorSource> VALUE_MAP = Arrays.stream(ErrorSource.values())
            .collect(Collectors.toMap(ErrorSource::name, t -> t, (t1, t2) -> t1));
}
