package com.elitescloud.boot.common.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 选择参数.
 *
 * @author Kaiser（wang shao）
 * @date 2022/9/20
 */
@Data
@ApiModel(description = "选择参数")
public class IdCodeNameCheckParam implements Serializable {
    private static final long serialVersionUID = -3585622745775582071L;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID", position = 1)
    private Long id;

    /**
     * 编码
     */
    @ApiModelProperty(value = "编码", position = 2)
    private String code;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称", position = 3)
    private String name;

    /**
     * 是否选择
     */
    @ApiModelProperty(value = "是否已选择", position = 4)
    private Boolean checked;
}
