package com.elitescloud.cloudt.common.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 租户隔离策略.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/23
 */
public enum TenantIsolateStrategy {
    /**
     * 隔离策略
     */
    DATABASE("数据库"), SCHEMA("schema"), FIELD("表字段"), NONE("不隔离");

    /**
     * 描述
     */
    private final String description;

    TenantIsolateStrategy(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    private static final Map<String, TenantIsolateStrategy> VALUE_MAP = Arrays.stream(TenantIsolateStrategy.values()).collect(Collectors.toMap(TenantIsolateStrategy::name, t -> t, (t1, t2) -> t1));

    public static TenantIsolateStrategy parse(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.get(value);
    }
}
