package com.elitescloud.boot.common.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 文件信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/26
 */
@Data
@ApiModel(description = "文件信息")
public class FileInfoVO implements Serializable {
    private static final long serialVersionUID = -4253958917199077051L;

    /**
     * 文件编码，文件的唯一标识
     */
    @ApiModelProperty(value = "文件编码，文件的唯一标识", position = 1)
    private String fileCode;

    /**
     * 文件原名称
     */
    @ApiModelProperty(value = "文件原名称", position = 2)
    private String originalName;

    /**
     * 文件大小，字节B
     */
    @ApiModelProperty(value = "文件大小，字节B", position = 3)
    private Long fileSize;

    /**
     * 文件名后缀
     */
    @ApiModelProperty(value = "文件名后缀", position = 4)
    private String suffix;

    /**
     * 文件内容类型，mime-type
     */
    @ApiModelProperty(value = "文件内容类型，mime-type", position = 5)
    private String mimeType;

    /**
     * 上传时间
     */
    @ApiModelProperty(value = "上传时间", position = 6)
    private LocalDateTime uploadTime;

    /**
     * 文件预览url
     */
    @ApiModelProperty(value = "文件预览url", position = 30)
    private String urlPreview;

    /**
     * 文件下载url
     */
    @ApiModelProperty(value = "文件下载url", position = 31)
    private String urlDownload;

    /**
     * 文件删除url
     */
    @ApiModelProperty(value = "文件删除url", position = 32)
    private String urlDelete;

    /**
     * 外部可访问的完整链接
     */
    @ApiModelProperty(value = "外部可直接访问的url", position = 33)
    private String url;
}
