package com.elitescloud.boot.constant;

import com.elitescloud.boot.base.SafeEnum;

import java.util.Set;

/**
 * 性别.
 *
 * @author Kaiser（wang shao）
 * @date 2022/9/21
 */
public class Gender extends SafeEnum<Gender> {
    private static final long serialVersionUID = -1661532117999454900L;

    public static Gender MALE = new Gender("MALE", "男");
    public static Gender FEMALE = new Gender("FEMALE", "女");
    public static Gender SECRET = new Gender("SECRET", "保密");
    public static Gender OTHER = new Gender("OTHER", "其它");

    public Gender() {
    }

    public Gender(String name) {
        super(name);
    }

    protected Gender(String name, String description) {
        super(name, description);
    }

    public static Set<Gender> all() {
        return SafeEnum.all(Gender.class);
    }

    public static Gender valueOf(String name) {
        return SafeEnum.valueOf(Gender.class, name);
    }
}
