package com.elitescloud.boot.common.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * 树形数据.
 *
 * @author Kaiser（wang shao）
 * @date 2023/1/11
 */
@Data
public class TreeRespParam<T> implements Serializable {
    private static final long serialVersionUID = -3929015640548296343L;

    /**
     * 节点ID
     */
    @ApiModelProperty(value = "节点ID", position = 1)
    private Long id;

    /**
     * 节点编码
     */
    @ApiModelProperty(value = "节点编码", position = 2)
    private String code;

    /**
     * 名称
     */
    @ApiModelProperty(value = "节点名称", position = 3)
    private String name;

    /**
     * 顺序
     */
    @ApiModelProperty(value = "顺序", position = 4)
    private Integer sortNo;

    /**
     * 上级组织ID
     */
    @ApiModelProperty(value = "上级ID", position = 5)
    private Long parentId;

    /**
     * 上级组织编码
     */
    @ApiModelProperty(value = "上级编码", position = 6)
    private String parentCode;

    /**
     * 是否有子节点
     */
    @ApiModelProperty(value = "是否有子节点", position = 11)
    private Boolean hasChildren;

    /**
     * 子组织节点
     */
    @ApiModelProperty(value = "子节点", position = 12)
    private List<T> children;

    public String getParentCode() {
        if (!StringUtils.hasText(parentCode)) {
            return null;
        }
        return parentCode;
    }

    public Boolean getHasChildren() {
        if (hasChildren != null) {
            return hasChildren;
        }
        return children != null && !children.isEmpty();
    }
}
