package com.elitescloud.boot.exception;

import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ErrorDetail;
import com.elitescloud.cloudt.common.base.ErrorDisplayType;
import com.elitescloud.cloudt.common.base.ErrorSource;
import org.apache.skywalking.apm.toolkit.trace.IgnoredException;

/**
 * 校验异常 (ValidationException)
 * 这类异常涉及输入的校验，例如用户输入了一个无效的电子邮箱地址。
 * 这类日志级别是WARN用于校验异常。例如，用户输入格式错误，但这并不会导致系统崩溃
 *
 * @author niuchen
 * @date 2023/9/22
 */
@IgnoredException
public class ValidationException extends BusinessException {

    private static final long serialVersionUID = -2205002357611194846L;

    public ValidationException() {
    }

    public ValidationException(ErrorSource source, String message, ErrorDisplayType displayType, ErrorDetail detail) {
        super(source, message, displayType, detail);
    }

    public ValidationException(String message, Throwable cause, ApiCode apiCode, Integer code, ErrorSource source, ErrorDisplayType displayType, ErrorDetail detail) {
        super(message, cause, apiCode, code, source, displayType, detail);
    }

    public ValidationException(String message) {
        super(message);
    }

    public ValidationException(ApiCode apiCode, String message) {
        super(apiCode, message);
    }

    public ValidationException(ApiCode apiCode, String message, Throwable throwable) {
        super(apiCode, message, throwable);
    }

    public ValidationException(Integer code, String message) {
        super(code, message);
    }

    public ValidationException(Integer code, String message, Throwable throwable) {
        super(code, message, throwable);
    }

    public ValidationException(String message, Throwable cause) {
        super(message, cause);
    }

    public ValidationException(Throwable cause) {
        super(cause);
    }

    public ValidationException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    @Override
    public ValidationException get() {
        return this;
    }

}
