package com.elitescloud.boot.common.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 文件信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/13
 */
@Data
public class FileByteVO implements Serializable {
    private static final long serialVersionUID = 2633901242146726290L;

    /**
     * 文件
     */
    @ApiModelProperty(value = "文件", position = 2)
    private byte[] bytes;

    /**
     * 文件原名称
     */
    @ApiModelProperty(value = "文件原名称", position = 2)
    private String originalName;

    /**
     * 文件大小，字节B
     */
    @ApiModelProperty(value = "文件大小，字节B", position = 3)
    private Long fileSize;

    /**
     * 文件名后缀
     */
    @ApiModelProperty(value = "文件名后缀", position = 4)
    private String suffix;

    /**
     * 文件内容类型，mime-type
     */
    @ApiModelProperty(value = "文件内容类型，mime-type", position = 5)
    private String mimeType;
}
