package com.elitescloud.cloudt.common.annotation;

/**
 * UDC的名称字段.
 * <p>
 * 使用与{@link SysCode}相反，该注解是注在udc值名称字段上，如
 * <pre>
 *     {@code
 *        @SysCodeName(sys = Application.name, mod = "employeeType")
 *        private String typeName;
 *        private String type;
 *     }
 * </pre>
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/8
 */
public @interface SysCodeName {

    /**
     * 领域码（应用编码）
     * <p>
     * 默认取当前应用编码，建议直接指定为固定的常量值，避免因系统融合时应用名称变化而取不到正确的应用名称
     *
     * @return 领域
     */
    String sys() default "";

    /**
     * UDC编码
     *
     * @return UDC编码
     */
    String mod();

    /**
     * UDC值编码字段
     * <p>
     * 默认为udc名称字段去掉Name后的字段，如值名称字段是typeName，则寻找的udc值编码字段是type
     *
     * @return 值编码字段
     */
    String udcField() default "";
}
