package com.elitescloud.cloudt.common.base;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 错误提示类型
 * <p>
 * 我们前端需要根据不同的异常类型来展示不同的异常信息。 如：不同类型弹窗样式或图片不同，如：警告类型的需要可以展示更多的堆栈数据，还需要可以发送联系管理员。
 * <li>提醒（REMINDER）：默认类型，如：成功，完成，可能有问题，结束。</li>
 * <li>失败（FAILED）：如：校验失败</li>
 * <li>错误（ERROR）：如：业务执行错误</li>
 * <li>警告（WARNING）：如：系统执行错误，jdbc错误，三方调用异常</li>
 * <li>未知（UNKNOWN）：如：特殊捕获异常，无法定位原因。 需要人工干预。</li>
 *
 * @author nc
 * @date 2023-09-27
 */
public enum ErrorDisplayType {
    /**
     * 错误显示类型
     */
    REMINDER("提醒"),
    FAILED("失败"),
    ERROR("错误"),
    WARNING("警告"),
    UNKNOWN("未知");

    private final String describe;

    ErrorDisplayType(String describe) {
        this.describe = describe;
    }

    /**
     * 根据名称解析
     *
     * @param name 名称
     * @return 错误源
     */
    public static ErrorDisplayType parse(String name) {
        return VALUE_MAP.get(name);
    }

    private static final Map<String, ErrorDisplayType> VALUE_MAP = Arrays.stream(ErrorDisplayType.values())
            .collect(Collectors.toMap(ErrorDisplayType::name, t -> t, (t1, t2) -> t1));

    public String getDescribe() {
        return describe;
    }
}
