package com.elitescloud.boot.constant;

/**
 * 租户相关常量.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/27
 */
public interface TenantConstant {

    /**
     * 配置前缀
     */
    String CONFIG_SERVICE_PREFIX = "elitesland.tenant";

    /**
     * 所有租户的缓存key
     */
    String CACHE_ALL_KEY = "cloudt_tenant";

    /**
     * 请求头 租户的ID
     */
    String HEADER_TENANT_ID = WebConstant.HEADER_TENANT_ID;

    /**
     * 请求头 租户的ID
     */
    String HEADER_TENANT_CODE = WebConstant.HEADER_TENANT_CODE;
    /**
     * 请求头 租户组织ID
     */
    String HEADER_TENANT_ORG_ID = WebConstant.HEADER_TENANT_ORG_ID;
    /**
     * 请求头 租户组织编码
     */
    String HEADER_TENANT_ORG_CODE = WebConstant.HEADER_TENANT_ORG_CODE;
    /**
     * http协议
     */
    String PROTOCOL_HTTP = "http://";

    /**
     * https协议
     */
    String PROTOCOL_HTTPS = "https://";

    /**
     * 路径前缀
     */
    String URI_PATH_DB_PREFIX = "/rpc/tenant/client/db";

    /**
     * 默认的租户ID
     */
    Long DEFAULT_TENANT_ID = -1L;

    /**
     * 实体过滤的filter名称
     */
    String ENTITY_FILTER_NAME = "filterByTenantId";

    /**
     * 实体过滤的filter名称
     */
    String ENTITY_FILTER_ORG_NAME = "filterByTenantOrgId";
}
