package com.elitescloud.cloudt.common.common;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Supplier;

/**
 * 自定义可序列化的Optional.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/27
 */
public class CloudtOptional<T extends Serializable> implements Serializable {
    private static final long serialVersionUID = 7910368329628507484L;

    private T value;

    public CloudtOptional(T value) {
        this.value = value;
    }

    public CloudtOptional() {
    }

    public static <T extends Serializable> CloudtOptional<T> of(T value) {
        return new CloudtOptional<>(value);
    }

    public static <T extends Serializable> CloudtOptional<T> empty() {
        return new CloudtOptional<>();
    }

    public boolean isPresent() {
        return value != null;
    }

    public boolean isEmpty() {
        return value == null;
    }

    public T orElse(T other) {
        if (value == null) {
            return other;
        }

        return value;
    }

    public T orElseThrow() {
        if (value == null) {
            throw new NoSuchElementException("No value present");
        }
        return value;
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (value != null) {
            return value;
        } else {
            throw exceptionSupplier.get();
        }
    }

    public void ifPresent(Consumer<? super T> action) {
        if (value != null) {
            action.accept(value);
        }
    }

    public T get() {
        return value;
    }
}
