package com.elitescloud.boot.common.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 行政区域.
 *
 * @author Kaiser（wang shao）
 * @date 2023/1/13
 */
@Data
@ApiModel(description = "行政区域信息")
public class AreaVO implements Serializable {
    private static final long serialVersionUID = -1948551902501473201L;

    /**
     * 国家编码
     */
    @ApiModelProperty(value = "国家编码", position = 1)
    private String countryCode;

    /**
     * 国家名称
     */
    @ApiModelProperty(value = "国家名称", position = 1)
    private String countryName;

    /**
     * 省份编码
     */
    @ApiModelProperty(value = "省份编码", position = 2)
    private String provinceCode;

    /**
     * 省份名称
     */
    @ApiModelProperty(value = "省份名称", position = 2)
    private String provinceName;

    /**
     * 市编码
     */
    @ApiModelProperty(value = "市编码", position = 3)
    private String cityCode;

    /**
     * 市名称
     */
    @ApiModelProperty(value = "市名称", position = 3)
    private String cityName;

    /**
     * 县编码
     */
    @ApiModelProperty(value = "县编码", position = 4)
    private String countyCode;

    /**
     * 县名称
     */
    @ApiModelProperty(value = "县名称", position = 4)
    private String countyName;
}
