package com.elitescloud.cloudt.common.annotation;

import java.lang.annotation.*;

/**
 * UDC翻译
 * <p>
 * 对返回对象中含有{@link SysCode} 和 {@link SysCodeName} 注解的字段进行翻译
 *
 * @author SHAO
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface SysCodeProc {

    /**
     * 是否递归翻译
     * <p>
     * 考虑到性能，默认仅对第一层对象进行翻译，支持Collection、Array、ApiResult、PagingVO等包括的对象进行翻译
     *
     * @return 是否
     */
    boolean isRecursion() default false;
}
