package com.elitescloud.cloudt.common.annotation.translate;

import java.lang.annotation.*;

/**
 * 组织翻译.
 * <p>
 * 根据组织ID翻译组织编码，示例：
 * <pre>
 *     {@code
 *
 *          private Long orgId;
 *
 *          @SysOrgCode(orgIdField = "orgId")
 *          private String orgCode;
 *     }
 * </pre>
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/10
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface SysOrgCode {

    /**
     * 组织ID字段
     *
     * @return 字段名称
     */
    String orgIdField();
}
