package com.elitescloud.boot.constant;

/**
 * 常量类.
 *
 * @author Kaiser（wang shao）
 * @date 2024/1/31
 */
public interface WebConstant {

    /**
     * 请求头 租户的ID
     */
    String HEADER_TENANT_ID = "X-Tenant-Id";

    /**
     * 请求头 租户的ID
     */
    String HEADER_TENANT_CODE = "X-Tenant-Code";
    /**
     * 请求头 租户组织ID
     */
    String HEADER_TENANT_ORG_ID = "X-TenantOrg-Id";
    /**
     * 请求头 租户组织编码
     */
    String HEADER_TENANT_ORG_CODE = "X-TenantOrg-Code";

    /**
     * 请求头-菜单编码
     */
    String HEADER_MENU_CODE = "menuCode";

    /**
     * 请求头-业务对象编码
     */
    String HEADER_BUSINESS_OBJECT = "X-Cloudt-BusinessObject";

    /**
     * 请求头-业务对象的操作编码
     */
    String HEADER_BUSINESS_OPERATION = "X-Cloudt-BusinessOperation";

    /**
     * 接口的编码
     * <p>
     *
     * @deprecated 改用业务对象操作
     */
    @Deprecated(since = "3.3.0")
    String HEADER_API_CODE = "apiCode";

    /**
     * 重复请求标识
     */
    String HEADER_REPEAT = "X-Cloudt-Repeat";

    /**
     * 请求体
     */
    String ATTRIBUTE_REQUEST_BODY = "cloudt-requestBody";

    /**
     * 业务对象
     */
    String ATTRIBUTE_BUSINESS_OBJECT = "cloudt-businessObject";

    /**
     * 业务对象的操作
     */
    String ATTRIBUTE_BUSINESS_OPERATION = "cloudt-businessObject-operation";

    /**
     * 是否启用UDC过滤
     */
    String ATTRIBUTE_UDC_FILTER_SUPPORT = "cloudt-udc-filter-support";
}
