package com.elitescloud.cloudt.common.annotation.translate;

import java.lang.annotation.*;

/**
 * 行政区域翻译.
 * <p>
 * 根据行政区域编码翻译行政区域名称，示例：
 * <pre>
 *     {@code
 *
 *          private String countryCode;
 *
 *          @SysAreaName(areaCodeField = "countryCode")
 *          private String countryName;
 *     }
 * </pre>
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/10
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface SysAreaName {

    /**
     * 行政区域编码字段
     *
     * @return 字段名称
     */
    String areaCodeField();
}
