package com.elitescloud.cloudt.common.annotation.translate;

import java.lang.annotation.*;

/**
 * 组织翻译.
 * <p>
 * 根据组织ID（或组织编码）翻译组织名称，示例：
 * <pre>
 *     {@code
 *
 *          private Long orgId;
 *
 *          @SysOrgName(orgIdField = "orgId")
 *          private String orgName;
 *     }
 * </pre>
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/10
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface SysOrgName {

    /**
     * 组织ID字段
     * <p>
     * {@link #orgIdField()} 与 {@link #orgCodeField()} 至少要有一个不为空，优先取 {@link #orgIdField()}
     *
     * @return 字段名称
     */
    String orgIdField() default "";

    /**
     * 组织编码字段
     *
     * @return 字段名称
     */
    String orgCodeField() default "";
}
