/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.base;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;

public class SafeEnum<T extends SafeEnum<T>>
implements Serializable,
Comparable<T> {
    private static final long serialVersionUID = 3946513070116495683L;
    private final String value;
    private final String description;
    private static final Map<Class<?>, TreeSet> INSTANCES = new HashMap(128);

    public SafeEnum() {
        this.value = null;
        this.description = null;
    }

    public SafeEnum(String value) {
        SafeEnum obj;
        this.value = value;
        this.description = value != null ? ((obj = (SafeEnum)SafeEnum.valueOf(this.getClass(), value)) == null ? null : obj.getDescription()) : null;
    }

    protected SafeEnum(String value, String description) {
        this.value = value;
        this.description = description;
        if (value == null) {
            return;
        }
        INSTANCES.computeIfAbsent(this.getClass(), t -> new TreeSet()).add(this);
    }

    public String getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    protected static <T> Set<T> all(Class<T> clazz) {
        TreeSet res = INSTANCES.get(clazz);
        if (res == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(res);
    }

    protected static <T> T valueOf(Class<T> clazz, String v) {
        if (v == null) {
            return null;
        }
        TreeSet res = INSTANCES.get(clazz);
        if (res == null) {
            return null;
        }
        for (Object r : res) {
            SafeEnum e = (SafeEnum)r;
            if (!Objects.equals(e.getValue(), v)) continue;
            return (T)r;
        }
        return null;
    }

    public int hashCode() {
        return Objects.hashCode(this.getValue());
    }

    public boolean equals(Object obj) {
        if (obj instanceof SafeEnum) {
            SafeEnum another = (SafeEnum)obj;
            return Objects.equals(this.getValue(), another.getValue());
        }
        return false;
    }

    @Override
    public int compareTo(@Nonnull T o) {
        return Objects.compare(this, o, Comparator.comparing(SafeEnum::getValue));
    }

    public String toString() {
        return this.getValue();
    }
}

