package com.elitesland.cbpl.fin.service;

import com.elitesland.cbpl.fin.domain.ReportResp;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import com.elitesland.fin.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.web.bind.annotation.PostMapping;

import java.util.List;
import java.util.Map;

@Unicom(domain = InvokeDomain.FINANCE, path = Application.PATH + BiReportAndArOrderSaveService.PATH)
public interface BiReportAndArOrderSaveService {

    String PATH = "/rpc/report";

    /**
     * 保存bi两张报表接口 返回报表信息
     */
    @PostMapping("/saveReport")
    Object saveReport(ReportResp resp);

    /**
     * 保存应收单信息 拿着报表信息查询合同信息
     */
    @PostMapping("/saveArOrder")
    ApiResult<Object> saveArOrder(List<Map<String, Object>> list);
}
