package com.elitesland.cbpl.fin.domain;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.vo.saleinv
 * @date 2022/5/7 11:28
 */
@Data
public class InvoApplyforDtlParam {

    @ApiModelProperty("关联id")
    private Long masId;

    @ApiModelProperty("发票号码")
    private String invNo;

    @ApiModelProperty("流水号")
    private String flowNo;

    @ApiModelProperty("发票代码")
    private String invCode;

    @ApiModelProperty("校验码")
    private String checkCode;

    @ApiModelProperty("原蓝票代码")
    private String blueInvCode;

    @ApiModelProperty("原蓝票号码")
    private String blueInvNo;

    @ApiModelProperty("红冲状态")
    private String redState;

    @ApiModelProperty("pdf链接")
    private String invPdfUrl;

    @ApiModelProperty("开票失败原因")
    private String invFailCause;

    @ApiModelProperty("应税货物或劳务、服务名称")
    private String taxName;

    @ApiModelProperty("税收分类编码")
    private String taxCode;

    @ApiModelProperty("发票行性质")
    private String invNature;

    @ApiModelProperty("开票日期")
    private LocalDateTime invDate;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("来源单号ID")
    private Long sourceId;

    @ApiModelProperty("来源行号")
    private Integer sourceLine;

    @ApiModelProperty("来源行号ID")
    private Long sourceLineId;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("规格型号")
    private String itemType;

    @ApiModelProperty("计量单位")
    private String uom;

    @ApiModelProperty("计量单位名称")
    private String uomName;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty("不含税总金额")
    private BigDecimal exclTaxAmt;

    @ApiModelProperty("不含税总金额(本位币)")
    private BigDecimal exclTaxCurAmt;

    @ApiModelProperty("发票类型")
    private String invType;

    @ApiModelProperty("红/蓝票")
    private String invKind;

    @ApiModelProperty("开票状态")
    private String invState;

    @ApiModelProperty("查验状态")
    private String examType;

}
