package com.elitesland.cbpl.fin.domain;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author: ryan.xu
 * @since 2023/4/13
 */
@Data
@ApiModel(value = "付款记录明细保存参数")
public class PaymentRecordsDSaveVO implements Serializable {

    @ApiModelProperty("付款记录主表ID")
    private Long masId;

    @ApiModelProperty("收费项目")
    private String chargeItems;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;

    @ApiModelProperty("收款单ID")
    private Long receiptId;

    @ApiModelProperty("实收金额")
    private BigDecimal realRecAmt;

    @ApiModelProperty("付款单状态")
    private String paymentStatus;
    @ApiModelProperty("是否参与开票")
    @SysCode(sys = "yst-fin",mod = "IS_BILLING")
    private String isToBilling;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("规格")
    private String itemSpec;

    @ApiModelProperty("含税单价")
    private BigDecimal transPrice;
}
