package com.elitesland.cbpl.fin.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.cbpl.fin.domain.PaymentRecordsSaveVO;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import com.elitesland.fin.Application;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * Created by lance on 2023/7/13.
 */
@Unicom(domain = InvokeDomain.FINANCE, path = Application.PATH + SavePaymentRecordsProvider.PATH)
public interface SavePaymentRecordsProvider {

    String PATH = "/rpc/paymentRecord";

    /**
     * 保存付款记录
     *
     * @param paymentRecordsSaveVO
     * @return
     */
    @PostMapping("/save")
    ApiResult<Long> save(@RequestBody PaymentRecordsSaveVO paymentRecordsSaveVO);

    /**
     * 生成付款记录并根据条件生成开票申请
     *
     * @param paymentRecordsSaveVOList
     * @return
     */
    @PostMapping("/saveAndGenerateInvoice")
    ApiResult<List<Long>> saveAndGenerateInvoice(@RequestBody List<PaymentRecordsSaveVO> paymentRecordsSaveVOList);


    /**
     * 根据条件生成开票申请
     *
     * @param salSoIdList
     * @return
     */
    @PostMapping("/generateInvoice")
    ApiResult<List<Long>> generateInvoice(@RequestBody List<Long> salSoIdList);


    /**
     * 保存付款记录
     *
     * @param saveVO
     * @return
     */
    @PostMapping("/saveW")
    Long savePaymentRecordsW(@RequestBody PaymentRecordsSaveVO saveVO);

}
