package com.elitesland.cbpl.franchisee.service;

import com.elitescloud.cloudt.common.constant.OpenFeignConstant;
import com.elitesland.cbpl.franchisee.domain.TsInvoiceRpcDTO;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.List;

/**
 * @author sunxw
 * @description
 * @Date 2023/7/12
 */
@Unicom(domain = "fos", path = InvoiceRpcService.PATH)
public interface InvoiceRpcService {

    String PATH = OpenFeignConstant.URI_PREFIX + "/invoice";

    @GetMapping(value = "/listByFranCode/{franchiseeCode}",produces = "application/json")
    List<TsInvoiceRpcDTO> listByFranCode(@PathVariable("franchiseeCode") String franchiseeCode);

}
