package com.elitesland.cbpl.franchisee.domain;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author eric.hao
 * @since 2023/05/29
 */
@Data
public class FranchiseeRpcDTO implements Serializable {

    private static final long serialVersionUID = -738013821057722339L;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("加盟商编码")
    private String franchiseeCode;

    @ApiModelProperty("加盟商名称")
    private String franchiseeName;

    @ApiModelProperty("加盟商状态")
    @SysCode(sys = "yst-franchisee", mod = "FRANCHISEE_STATUS")
    private String franchiseeStatus;
    private String franchiseeStatusName;

    @ApiModelProperty("渠道类型")
    @SysCode(sys = "yst-franchisee", mod = "CHANNEL_TYPE")
    private String channelType;
    private String channelTypeName;

    @ApiModelProperty("KA渠道类型")
    private String kaChannelType;

    @ApiModelProperty("申请人")
    private String applyName;

    @ApiModelProperty("注册国家")
    @SysCode(sys = "yst-supp", mod = "COM_COUNTRY")
    private String registerCountry;
    private String registerCountryName;

    @ApiModelProperty("手机号")
    private String mobile;

    @ApiModelProperty("联系人邮箱")
    private String email;

    @ApiModelProperty(name = "身份证号")
    private String idCard;

    @ApiModelProperty(name = "出生日期")
    private LocalDate birthday;

    @ApiModelProperty("住址")
    private String address;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司简称")
    private String ouAbbr;

    @ApiModelProperty("英文名称")
    private String ouEnName;

    @ApiModelProperty("统一社会信用代码")
    private String certNo;

    @ApiModelProperty("企业性质")
    @SysCode(sys = "yst-franchisee", mod = "COMP_PROP")
    private String compProp;
    private String compPropName;

    @ApiModelProperty("实缴资本")
    private String paidFund;

    @ApiModelProperty("注册资本")
    private String registerFund;

    @ApiModelProperty("注册日期")
    private LocalDate registerDate;

    @ApiModelProperty("注册地址")
    private String registerAddress;

    @ApiModelProperty("法定代表人")
    private String reprName;

    @ApiModelProperty("注册电话")
    private String registerMobile;

    @ApiModelProperty("经营地省")
    private String busiProvince;

    @ApiModelProperty("经营地城市")
    private String busiCity;

    @ApiModelProperty("经营地区县")
    private String busiCountry;

    @ApiModelProperty("经营地详细地址")
    private String busiDetailAddr;

    @ApiModelProperty("公司简介")
    private String franchiseeRemark;

    @ApiModelProperty(name = "开户银行")
    private String invBankNo;

    @ApiModelProperty("默认发票类型")
    @SysCode(sys = "yst-fin", mod = "INV_TYPE")
    private String invType;
    private String invTypeName;

    @ApiModelProperty(name = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(name = "税码")
    private String taxRateNo;

    @ApiModelProperty(name = "开户支行")
    private String bankRanch;

    @ApiModelProperty(name = "银行账户")
    private String bankAccount;

    @ApiModelProperty("付款条款")
    @SysCode(sys = "yst-franchisee", mod = "PAYMENT_TERM")
    private String paymentTerm;
    private String paymentTermName;

    @ApiModelProperty(name = "币种")
    private String currCode;
    @ApiModelProperty(name = "币种名称")
    private String currCodeName;

    @ApiModelProperty("付款方式")
    @SysCode(sys = "yst-franchisee", mod = "PAY_METHOD")
    private String payMethod;
    private String payMethodName;

    @ApiModelProperty("税号")
    private String vatNumber;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("业务员ID")
    private Long empId;

    @ApiModelProperty("业务员编码")
    private String empCode;

    @ApiModelProperty("业务员名称")
    private String empName;

    /**
     * 是否白名单
     */
    @ApiModelProperty(name = "是否白名单")
    private String isWhite;
}
