package com.elitesland.cbpl.franchisee.service;

import com.elitescloud.cloudt.common.constant.OpenFeignConstant;
import com.elitesland.cbpl.franchisee.domain.FranchiseeRpcDTO;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author eric.hao
 * @since 2023/05/29
 */
@Unicom(domain = "fos", path = FranchiseeRpcService.PATH)
public interface FranchiseeRpcService {

    String PATH = OpenFeignConstant.URI_PREFIX + "/fos";

    /**
     * 加盟商查询
     *
     * @param franchiseeCodes 加盟商编码
     * @return 加盟商数据
     */
    @PostMapping("/franchiseeByCodes")
    List<FranchiseeRpcDTO> franchiseeByCodes(@RequestBody List<String> franchiseeCodes);
    /**
     * 加盟商查询
     *
     * @param
     * @return 加盟商数据
     */
    @GetMapping(value = "/franchiseeByUserId/{userId}",produces = "application/json")
    FranchiseeRpcDTO franchiseeByUserId(@PathVariable("userId") Long userId);
}
