package com.elitesland.cbpl.franchisee.domain;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Author: ryan.xu
 * @since 2023/4/7
 */
@Data
@ApiModel("子加盟商档案返回")
public class FranchiseeSubRpcDTO implements Serializable {
    private static final long serialVersionUID = 8999357515078934610L;

    @ApiModelProperty("id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("加盟商编码")
    private String franchiseeCode;

    @ApiModelProperty("加盟商名称")
    private String franchiseeName;
    @ApiModelProperty("子加盟商编码")
    private String franchiseeSubCode;

    @ApiModelProperty("子加盟商名称")
    private String franchiseeSubName;

    @SysCode(sys = "yst-franchisee", mod = "FANCHISEE_ENABLE")
    @ApiModelProperty("是否启用")
    private Integer enable;
    private String enableName;

    @ApiModelProperty("创建人")
    private String creator;
    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;
    @ApiModelProperty("修改时间")
    private LocalDateTime modifyTime;
}
