package com.elitesland.cbpl.franchisee.service;

import com.elitescloud.cloudt.common.constant.OpenFeignConstant;
import com.elitesland.cbpl.franchisee.domain.FranchiseeRpcDTO;
import com.elitesland.cbpl.franchisee.domain.FranchiseeSubRpcDTO;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author eric.hao
 * @since 2023/05/29
 */
@Unicom(domain = "fos", path = FranchiseeRpcService.PATH)
public interface FranchiseeRpcService {

    String PATH = OpenFeignConstant.URI_PREFIX + "/fos";

    /**
     * 加盟商查询
     *
     * @param franchiseeCodes 加盟商编码/sap客户编码
     * @return 加盟商数据
     */
    @PostMapping("/franchiseeByCodes")
    List<FranchiseeRpcDTO> franchiseeByCodes(@RequestBody List<String> franchiseeCodes);

    /**
     * 根据id获取加盟商
     * @param masId
     * @return
     */
    @GetMapping(value = "/franchiseeById/{masId}",produces = "application/json")
    FranchiseeRpcDTO franchiseeById(@PathVariable("masId") Long masId);

    @PostMapping(value = "/franchiseeByIds",produces = "application/json")
    List<FranchiseeRpcDTO> franchiseeByIds(@RequestBody List<Long> ids);
    /**
     * 加盟商查询
     *
     * @param channelType 加盟商编码/sap客户编码
     * @return 加盟商数据
     */
    @PostMapping("/franchiseeByChannelType")
    List<FranchiseeRpcDTO> franchiseeByChannelType(@RequestParam("channelType") String channelType);
    /**
     * 加盟商查询
     *
     * @param
     * @return 加盟商数据
     */
    @GetMapping(value = "/franchiseeByUserId/{userId}",produces = "application/json")
    FranchiseeRpcDTO franchiseeByUserId(@PathVariable("userId") Long userId);


    /**
     * 子加盟商查询
     *
     * @param franchiseeSubCodes 加盟商编码
     * @return 加盟商数据
     */
    @PostMapping("/franchiseeSubByCodes")
    List<FranchiseeSubRpcDTO> franchiseeSubByCodes(@RequestBody List<String> franchiseeSubCodes);


    /**
     * 主加盟商查询
     *
     * @param franchiseeCodes 加盟商编码
     * @return 加盟商数据
     */
    @PostMapping("/subFranchiseeByCodes")
    List<FranchiseeSubRpcDTO> subFranchiseeByCodes(@RequestBody List<String> franchiseeCodes);
}
