package com.elitesland.cbpl.franchisee.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.constant.OpenFeignConstant;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

/**
 * @author sunxw
 * @description
 * @Date 2023/7/10
 */
@Unicom(domain = "fos", path = FsmRpcService.PATH)
public interface FsmRpcService {

    String PATH = OpenFeignConstant.URI_PREFIX + "/fos/fsm";

    /**
     * 异步上传excel文件到OSS
     */
    @PostMapping(value = "/uploadExcel", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    ApiResult<Object> uploadExcel(@RequestPart(value = "file") MultipartFile file);

}
