package com.elitesland.cbpl.franchisee.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.cbpl.franchisee.domain.MessageRpcDTO;
import com.elitesland.cbpl.franchisee.domain.SendMessageRpcDTO;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Unicom(domain = "fos", path = MessageRpcService.PATH)
public interface MessageRpcService {
    String PATH ="/rpc/message";
    @PostMapping("/payment")
    public void orderPaymentMsg(@RequestBody MessageRpcDTO messageRpcDTO);
    @PostMapping("/isAmt")
    public void isAmtMsg(@RequestBody MessageRpcDTO messageRpcDTO);
    @PostMapping("/send")
    ApiResult<Object> send(@RequestBody SendMessageRpcDTO sendMessageRpcDTO);


    @PostMapping("/sendFin")
    ApiResult<Object> sendFin(@RequestBody SendMessageRpcDTO sendMessageRpcDTO);

    @PostMapping("/accountSend")
    public  ApiResult<Object> accountSend(@RequestBody MessageRpcDTO messageRpcDTO);

    @PostMapping("/accountNotWarinng")
    public void accountNotWarinng(@RequestBody MessageRpcDTO messageRpcDTO);

}
