package com.elitesland.cbpl.mdm.rpc;

import com.elitesland.cbpl.mdm.Application;
import com.elitesland.cbpl.mdm.rpc.param.save.SyncStoreSaveDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @Author: ryan.xu
 * @since 2023/3/25
 */
@FeignClient(name = Application.NAME, path = SyncStoreRpcService.URI)
@Validated
public interface SyncStoreRpcService {

    String URI = Application.URI_PREFIX + "/syncStore";

    @PostMapping("/save")
    void syncStore(@RequestBody List<SyncStoreSaveDTO> param);

    @GetMapping("/rpc/tenant")
    void tenant();

}
