package com.elitesland.cbpl.mdm.rpc;

import com.elitesland.cbpl.mdm.rpc.param.resp.InvoiceRpcDTO;
import com.elitesland.cbpl.mdm.rpc.param.resp.StoreRpcDTO;
import com.elitesland.cbpl.mdm.rpc.param.save.SynStoreIsWhiteParam;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import com.elitesland.support.provider.Application;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Unicom(domain = InvokeDomain.SUPPORT, path = Application.PATH + StoreRpcService.URI)
public interface StoreRpcService {

    String URI = "/rpc/yst/support/org/store";

    @PostMapping("/findByCode")
    List<StoreRpcDTO> findByCode(@RequestBody List<String> storeCodes);

    @PostMapping("/invoice")
    List<InvoiceRpcDTO> invoiceByStoreCode(@RequestBody List<String> storeCodes);

    @PostMapping("/list")
    List<InvoiceRpcDTO> invoiceList(@RequestBody List<String> invTitleList);
    @PostMapping("/findByCodeOne")
    public StoreRpcDTO findByCodeOne(String storeCodes);

    @PostMapping("/synStoreIsWhite")
    public StoreRpcDTO synStoreIsWhite(List<SynStoreIsWhiteParam> storeCodeList);

    @PostMapping("/franchiseeCodeQueryStore")
    public List<String> franchiseeCodeQueryStore(String storeCode);
}
