package com.elitesland.cbpl.mdm.rpc.param.save;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Author: ryan.xu
 * @since 2023/5/6
 */
@Data
@ApiModel("门店同步保存参数")
public class SyncStoreSaveDTO implements Serializable {
    private static final long serialVersionUID = -370911243249307408L;

    @ApiModelProperty(value = "门店编码")
    @NotBlank(message = "门店编码不能为空")
    private String storeCode;

    @ApiModelProperty(value = "门店类型")
    @NotBlank(message = "门店类型不能为空")
    private String storeType;

    @ApiModelProperty("门店中文名称")
    @NotBlank(message = "门店中文名称不能为空")
    private String storeNameCN;

    @ApiModelProperty("门店英文名称")
    @NotBlank(message = "门店英文名称不能为空")
    private String storeNameEN;

    @ApiModelProperty("是否激活：0未激活；1激活；")
    @NotBlank(message = "是否激活不能为空")
    private String active;

    @ApiModelProperty("加盟商编码：storeType=1时必填")
    private String franchiseeCode;

    private String franchiseeName;

    @ApiModelProperty("公司编码：storeType=0时必填")
    private String ouCode;

    @ApiModelProperty("完整地址，包含省市区")
    private String detailAddress;

    @ApiModelProperty("营业开始日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startBusinessDate;

    @ApiModelProperty("门店经理")
    private String storeRGMName;

    @ApiModelProperty("门店电话")
    private String storePhone;

    @ApiModelProperty("门店传真")
    private String storeFax;

    @ApiModelProperty("门店邮箱")
    private String storeMail;

    @ApiModelProperty("省")
    private String province;

    @ApiModelProperty("市")
    private String city;

    @ApiModelProperty("区")
    private String district;

    @ApiModelProperty("区域")
    private String region;

    @ApiModelProperty("经度")
    private String longitude;

    @ApiModelProperty("纬度")
    private String latitude;

}
