package com.elitesland.cbpl.mdm.rpc.param.save;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Author: ryan.xu
 * @since 2023/5/6
 */
@Data
@ApiModel("门店同步保存参数")
public class SyncStoreSaveDTO implements Serializable {
    private static final long serialVersionUID = -370911243249307408L;


    @ApiModelProperty(value = "门店编码")
    @NotBlank(message = "门店编码不能为空")
    private String storeCode;

    @ApiModelProperty(value = "门店类型")
    @NotBlank(message = "门店类型不能为空")
    private String storeType;

    @ApiModelProperty("门店中文名称")
    @NotBlank(message = "门店中文名称不能为空")
    private String storeNameCN;

    @ApiModelProperty("门店英文名称")
    @NotBlank(message = "门店英文名称不能为空")
    private String storeNameEN;

    @ApiModelProperty("是否激活：0未激活；1激活；")
    @NotBlank(message = "是否激活不能为空")
    private String active;

    @ApiModelProperty("加盟商编码：storeType=1时必填")
    private String franchiseeCode;

    private String franchiseeName;

    @ApiModelProperty("公司编码：storeType=0时必填")
    private String ouCode;

    @ApiModelProperty("完整地址，包含省市区")
    private String detailAddress;

    @ApiModelProperty("营业开始日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startBusinessDate;

    @ApiModelProperty("门店经理")
    private String storeRGMName;

    @ApiModelProperty("门店电话")
    private String storePhone;

    @ApiModelProperty("门店传真")
    private String storeFax;

    @ApiModelProperty("门店邮箱")
    private String storeMail;

    @ApiModelProperty("省")
    private String province;

    @ApiModelProperty("市")
    private String city;

    @ApiModelProperty("区")
    private String district;

    @ApiModelProperty("区域")
    private String region;

    @ApiModelProperty("经度")
    private String longitude;

    @ApiModelProperty("纬度")
    private String latitude;

    @ApiModelProperty("门店模式")
    private String strategyType;

    @ApiModelProperty("门店code（Local ID）")
    private String storeLocalCode;
    @ApiModelProperty("品牌code(tims/ppy)")
    private String brandCode;
    @ApiModelProperty("经营方式(1-自营店、2-城市加盟、3-创新加盟、4-合资)")
    private Integer modeOfOperation;
    @ApiModelProperty("经营方式(1-自营店、2-城市加盟、3-创新加盟、4-合资)")
    private String modeOfOperationName;
    @ApiModelProperty("门店code")
    private String businessAreaType;
    @ApiModelProperty("门店code")
    private String businessAreaSubType;
    @ApiModelProperty("门店code")
    private String affiliatedCompany;
    @ApiModelProperty("门店code")
    private String provinceCode;
    @ApiModelProperty("门店code")
    private String cityCode;
    @ApiModelProperty("门店code")
    private String cityEn;
    @ApiModelProperty("门店code")
    private String districtCode;
    @ApiModelProperty("门店code")
    private String area;
    @ApiModelProperty("门店code")
    private String storeTypeCn;
    @ApiModelProperty("门店code")
    private String storeTypeEn;
    @ApiModelProperty("门店code")
    private String storeCompany;
    @ApiModelProperty("门店code")
    private String developmentTeam;
    @ApiModelProperty("门店code")
    private String developmentPrincipal;
    @ApiModelProperty("门店code")
    private String developmentPrincipalName;
    @ApiModelProperty("门店code")
    private String developmentPrincipalMail;
    @ApiModelProperty("门店code")
    private String designType;
    @ApiModelProperty("门店code")
    private String storeOpeningDate;
    @ApiModelProperty("门店code")
    private String storeClosingDate;
    @ApiModelProperty("门店code")
    private String subFranchiseeCode;
    @ApiModelProperty("门店code")
    private String subFranchiseeName;
    @ApiModelProperty("门店code")
    private String storeEmail;
    @ApiModelProperty("门店code")
    private Integer storeStatus;
    @ApiModelProperty("门店code")
    private String storeStatusName;
    @ApiModelProperty("门店code")
    private String designHeadId;
    @ApiModelProperty("门店code")
    private String designHeadName;
    @ApiModelProperty("门店code")
    private String engineeringManagerId;
    @ApiModelProperty("门店code")
    private String engineeringManagerName;
    @ApiModelProperty("门店code")
    private String indoorUseArea;
    @ApiModelProperty("门店code")
    private String storeFohArea;
    @ApiModelProperty("门店code")
    private String storeBohArea;
    @ApiModelProperty("门店code")
    private String storeCustomerArea;
    @ApiModelProperty("门店code")
    private String outerPendulumUseArea;
    @ApiModelProperty("门店code")
    private Integer seatsNumberInside;
    @ApiModelProperty("门店code")
    private Integer seatsNumberOutside;
    @ApiModelProperty("门店code")
    private String attachments;
    @ApiModelProperty("门店code")
    private Boolean assistflag;
    @ApiModelProperty("门店code")
    private String sapCostCenterCode;
    @ApiModelProperty("门店code")
    private String affiliatedSapCompanyCode;
    @ApiModelProperty("门店code")
    private String storeCashDepositAccount;
    @ApiModelProperty("门店code")
    private String storeCashDepositBankName;
    @ApiModelProperty("门店code")
    private String storeCashDepositBank;
    @ApiModelProperty("门店code")
    private String companyHead;
    @ApiModelProperty("门店code")
    private String registrationNumber;
    @ApiModelProperty("门店code")
    private String addressPhone;
    @ApiModelProperty("门店code")
    private String accountBankAccountNumber;
    @ApiModelProperty("门店code")
    private String opTeam;
    @ApiModelProperty("门店code")
    private String businessHead;
    @ApiModelProperty("门店code")
    private String needLicense;
    @ApiModelProperty("门店code")
    private String businessTime;
    @ApiModelProperty("门店code")
    private String businessTerminationTime;
    @ApiModelProperty("门店code")
    private String dayCoffeeNightAlcohol;
    @ApiModelProperty("门店code")
    private String gmStaff;
    @ApiModelProperty("门店code")
    private String omStaff;
    @ApiModelProperty("门店code")
    private String dmStaff;
    @ApiModelProperty("门店code")
    private String sicStaff;
    @ApiModelProperty("门店code")
    private String sicStaffPhone;
    @ApiModelProperty("门店code")
    private String restPriceT;
    @ApiModelProperty("门店code")
    private String mpPriceT;
    @ApiModelProperty("门店code")
    private String platformPriceT;
    @ApiModelProperty("门店code")
    private String benchmarkingCode;
    @ApiModelProperty("门店code")
    private String planStoreOpenDate;
}
