package com.elitesland.cbpl.mdm.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.cbpl.mdm.Application;
import com.elitesland.cbpl.mdm.rpc.param.save.TsOrgTreeAutoLinkParam;
import com.elitesland.cbpl.mdm.rpc.resp.TsOrgTreeDRpcDTO;
import com.elitesland.cbpl.mdm.rpc.resp.TsOrgTreeDetailRpcVO;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * Created by lance on 2023/8/15.
 */
@Unicom(domain = InvokeDomain.SUPPORT, path = TsOrgTreeRpcService.URI)
public interface TsOrgTreeRpcService {

    String URI = Application.URI_PREFIX + "/tsTreeRpc";

    @PostMapping("/listAll")
    @ApiOperation("组织树全部查询")
    ApiResult<List<TsOrgTreeDetailRpcVO>> listAll();

    @PostMapping("/treeDetailSearch")
    @ApiOperation("组织树明细树形显示内容")
    ApiResult<List<TsOrgTreeDRpcDTO>> orgBuTreeDSearchByIdList(@RequestBody List<Long> idList);

    @PostMapping("/autoLinkOrgTree")
    @ApiOperation("自动挂靠创建组织树")
    ApiResult<Object> autoLinkByRelatedInfo(@RequestBody TsOrgTreeAutoLinkParam param);

    @PostMapping("/deleteOrgTree")
    @ApiOperation("删除组织树")
    ApiResult<Object> deleteOrgTree(@RequestBody TsOrgTreeAutoLinkParam param);
}
