package com.elitesland.cbpl.mdm.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.cbpl.mdm.rpc.param.resp.FranchiseeStoreRpcDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.cbpl.mdm.rpc.param.resp.FranchiseeStoreRpcDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.cbpl.mdm.rpc.param.resp.InvoiceRpcDTO;
import com.elitesland.cbpl.mdm.rpc.param.resp.StoreRpcDTO;
import com.elitesland.cbpl.mdm.rpc.param.save.SynStoreIsWhiteParam;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import com.elitesland.support.provider.Application;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Unicom(domain = InvokeDomain.SUPPORT, path = Application.PATH + StoreRpcService.URI)
public interface StoreRpcService {

    String URI = "/rpc/yst/support/org/store";

    @PostMapping("/findByCode")
    List<StoreRpcDTO> findByCode(@RequestBody List<String> storeCodes);
    @PostMapping("/findById")
    List<StoreRpcDTO> findById(@RequestBody List<Long> findById);
    @PostMapping("/findByCodeOrName")
    List<StoreRpcDTO> findByCodeOrName(@RequestBody String storeCodeOrName);

    @PostMapping("/invoice")
    List<InvoiceRpcDTO> invoiceByStoreCode(@RequestBody List<String> storeCodes);

    @PostMapping("/list")
    List<InvoiceRpcDTO> invoiceList(@RequestBody List<String> invTitleList);
    @PostMapping("/findByCodeOne")
    public StoreRpcDTO findByCodeOne(@RequestParam(value = "storeCodes") String storeCodes);

    @PostMapping("/synStoreIsWhite")
    public ApiResult<Object> synStoreIsWhite(@RequestBody List<SynStoreIsWhiteParam> storeCodeList);

    @PostMapping("/franchiseeCodeQueryStore")
    public List<String> franchiseeCodeQueryStore(@RequestBody String franchiseeCode);
    @PostMapping("/updateWhCodeByCityCode")
    public ApiResult<Object> updateWhCodeByStoreCode(@RequestBody List<FranchiseeStoreRpcDTO> franchiseeStoreRpcDTOList);

    /**
     * 根据加盟商code查询门店下的开票主体
     * @param franchiseeCode
     * @return
     */
    @PostMapping("/franchiseeCodeQueryInvoice")
    public List<InvoiceRpcDTO> franchiseeCodeQueryInvoice(@RequestParam("storeId") List<Long> storeId,@RequestParam("franchiseeCode") String franchiseeCode);
}
