package com.elitesland.cbpl.mdm.rpc.param.save;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel("公司银行信息")
public class OuBankApiRespVo implements Serializable {
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("开户银行")
    private String invBankNo;

    @ApiModelProperty("开户银行支行名称")
    private String branchName;

    @ApiModelProperty("银行账号")
    private String bankAccount;

    @ApiModelProperty("联行号")
    private String uniBankNo;

    public OuBankApiRespVo() {
    }
}
