package com.elitesland.cbpl.mdm.rpc;

import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import com.elitesland.support.provider.Application;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * Created by lance on 2023/11/6.
 */
@Unicom(domain = InvokeDomain.SUPPORT, path = Application.PATH + TsItemCateRpcService.PATH)
public interface TsItemCateRpcService {

    String PATH = "/rpc/itemCate";

    /**
     * 通过商品编码获取商品品类
     *
     * @param itemCodes
     * @return
     */
    @PostMapping("/queryItemCatePathByItemCodes")
    Map<String, Map<String, String>> queryItemCatePathByItemCodes(@RequestBody List<String> itemCodes);

    /**
     * 通过商品品类编码或者名称，模糊搜索商品编码
     *
     * @param itemCate
     * @return
     */
    @PostMapping("/queryItemCodeByItemCateCodeOrItemCateName")
    List<String> queryItemCodeByItemCateCodeOrItemCateName(@RequestParam(value = "itemCate") String itemCate);
}
