package com.elitesland.cbpl.mdm.rpc.param.save;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Author: ryan.xu
 * @since 2023/5/6
 */
@Data
@ApiModel("门店同步保存参数")
public class SyncStoreSaveDTO implements Serializable {
    private static final long serialVersionUID = -370911243249307408L;


    @ApiModelProperty(value = "门店编码")
    @NotBlank(message = "门店编码不能为空")
    private String storeCode;

    @ApiModelProperty(value = "门店类型")
    @NotBlank(message = "门店类型不能为空")
    private String storeType;

    @ApiModelProperty("门店中文名称")
    @NotBlank(message = "门店中文名称不能为空")
    private String storeNameCN;

    @ApiModelProperty("门店英文名称")
    @NotBlank(message = "门店英文名称不能为空")
    private String storeNameEN;

    @ApiModelProperty("是否激活：0未激活；1激活；")
    @NotBlank(message = "是否激活不能为空")
    private String active;

    @ApiModelProperty("加盟商编码：storeType=1时必填")
    private String franchiseeCode;

    private String franchiseeName;

    @ApiModelProperty("公司编码：storeType=0时必填")
    private String ouCode;

    @ApiModelProperty("完整地址，包含省市区")
    private String detailAddress;

    @ApiModelProperty("营业开始日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startBusinessDate;

    @ApiModelProperty("门店经理")
    private String storeRGMName;

    @ApiModelProperty("门店电话")
    private String storePhone;

    @ApiModelProperty("门店传真")
    private String storeFax;

    @ApiModelProperty("门店邮箱")
    private String storeMail;

    @ApiModelProperty("省")
    private String province;

    @ApiModelProperty("市")
    private String city;

    @ApiModelProperty("区")
    private String district;

    @ApiModelProperty("区域")
    private String region;

    @ApiModelProperty("经度")
    private String longitude;

    @ApiModelProperty("纬度")
    private String latitude;

    @ApiModelProperty("门店模式")
    private String strategyType;

    @ApiModelProperty("门店code")
    private String storeGlobalCode;
    @ApiModelProperty("品牌code(tims/ppy)")
    private String brandCode;
    @ApiModelProperty("经营方式(1-自营店、2-城市加盟、3-创新加盟、4-合资)")
    private Integer modeOfOperation;
    @ApiModelProperty("经营方式(1-自营店、2-城市加盟、3-创新加盟、4-合资)")
    private String modeOfOperationName;
    @ApiModelProperty("商圈类型({办公、商业、沿街类商铺、街铺、交通枢纽、其他})")
    private String businessAreaType;
    @ApiModelProperty("商圈细类({高速服务区、医院、小型商业体、混合街区、商业街、机场、会展、沿街商铺、总部店、麦德龙、学校、写字楼、地标型、高铁、写字楼+、旅游、配套型、区域型、社区型})")
    private String businessAreaSubType;
    @ApiModelProperty("所属公司主体")
    private String affiliatedCompany;
    @ApiModelProperty("省编码")
    private String provinceCode;
    @ApiModelProperty("城市编码")
    private String cityCode;
    @ApiModelProperty("城市英文缩写")
    private String cityEn;
    @ApiModelProperty("区编码")
    private String districtCode;
    @ApiModelProperty("地理区域({华东、华南、华北、华西})")
    private String area;
    @ApiModelProperty("门店类型-中文({金枫、红枫、捷枫、灵枫})")
    private String storeTypeCn;
    @ApiModelProperty("门店类型-英文")
    private String storeTypeEn;
    @ApiModelProperty("门店公司名（营业执照）")
    private String storeCompany;
    @ApiModelProperty("开发团队({华东、华南、华北、华西})")
    private String developmentTeam;
    @ApiModelProperty("开发负责人ID")
    private String developmentPrincipal;
    @ApiModelProperty("开发负责人名称")
    private String developmentPrincipalName;
    @ApiModelProperty("开发负责人邮箱")
    private String developmentPrincipalMail;
    @ApiModelProperty("设计风格")
    private String designType;
    @ApiModelProperty("实际开业日期")
    private String storeOpeningDate;
    @ApiModelProperty("实际闭店日期")
    private String storeClosingDate;
    @ApiModelProperty("子加盟商编码")
    private String subFranchiseeCode;
    @ApiModelProperty("子加盟商名称")
    private String subFranchiseeName;
    @ApiModelProperty("邮箱")
    private String storeEmail;
    @ApiModelProperty("门店状态(0-预备开店、1-已开店、2-永久闭店、3-暂停推进、4-终止推进、5-暂时休业)")
    private String storeStatus;
    @ApiModelProperty("门店状态")
    private String storeStatusName;
    @ApiModelProperty("设计负责人ID")
    private String designHeadId;
    @ApiModelProperty("设计负责人名称")
    private String designHeadName;
    @ApiModelProperty("工程负责人ID")
    private String engineeringManagerId;
    @ApiModelProperty("工程负责人名称")
    private String engineeringManagerName;
    @ApiModelProperty("室内使用面积")
    private String indoorUseArea;
    @ApiModelProperty("门店FOH面积")
    private String storeFohArea;
    @ApiModelProperty("门店BOH面积")
    private String storeBohArea;
    @ApiModelProperty("门店客座区面积")
    private String storeCustomerArea;
    @ApiModelProperty("室外使用面积")
    private String outerPendulumUseArea;
    @ApiModelProperty("室内座位数")
    private Integer seatsNumberInside;
    @ApiModelProperty("外摆座位数")
    private Integer seatsNumberOutside;
    @ApiModelProperty("附件")
    private String attachments;
    @ApiModelProperty("是否提供工程和设计服务")
    private Integer assist;
    @ApiModelProperty("成本中心编码")
    private String sapCostCenterCode;
    @ApiModelProperty("所属SAP公司编码")
    private String affiliatedSapCompanyCode;
    @ApiModelProperty("门店现金存款账号")
    private String storeCashDepositAccount;
    @ApiModelProperty("门店现金存行名称")
    private String storeCashDepositBankName;
    @ApiModelProperty("门店现金存行银行")
    private String storeCashDepositBank;
    @ApiModelProperty("开票主体")
    private String companyHead;
    @ApiModelProperty("纳税人识别号")
    private String registrationNumber;
    @ApiModelProperty("开票地址、电话")
    private String addressPhone;
    @ApiModelProperty("开户行及账号")
    private String accountBankAccountNumber;
    @ApiModelProperty("营运团队")
    private String opTeam;
    @ApiModelProperty("业务负责人")
    private String businessHead;
    @ApiModelProperty("是否需要许可证入店")
    private String needLicense;
    @ApiModelProperty("门店营业时间")
    private String businessTime;
    @ApiModelProperty("营业终止时间")
    private String businessTerminationTime;
    @ApiModelProperty("日咖夜酒")
    private String dayCoffeeNightAlcohol;
    @ApiModelProperty("GM员工姓名")
    private String gmStaff;
    @ApiModelProperty("OM员工姓名")
    private String omStaff;
    @ApiModelProperty("DM员工姓名")
    private String dmStaff;
    @ApiModelProperty("SIC员工姓名")
    private String sicStaff;
    @ApiModelProperty("SIC员工手机号")
    private String sicStaffPhone;
    @ApiModelProperty("堂食价格T次")
    private String restPriceT;
    @ApiModelProperty("小程序外送价格T次")
    private String mpPriceT;
    @ApiModelProperty("平台外送价格T次")
    private String platformPriceT;
    @ApiModelProperty("对标门店Local ID")
    private String benchmarkingCode;
    @ApiModelProperty("预计开店日期")
    private String planStoreOpenDate;

    // 20231121 新增财务字段
    @ApiModelProperty("支付宝账号")
    private String alipayAccountEmail;
    // 20231121 新增财务字段
    @ApiModelProperty("支付宝PID")
    private String alipayPid;
    // 20231121 新增财务字段
    @ApiModelProperty("支付宝名称")
    private String alipayName;
    // 20231121 新增财务字段
    @ApiModelProperty("是否一般纳税人")
    private String registrationType;
    @ApiModelProperty("开票类型")
    private String invType;
    @ApiModelProperty("开户银行UDCcode")
    private String invBank;

    @ApiModelProperty("开户银行UDCcode")
    private String storePaymentOpeningBankCode;
    @ApiModelProperty("加盟门店付款信息")
    private String storePaymentOpeningBankBranch;
    @ApiModelProperty("加盟门店付款信息")
    private String storePaymentBankAccountName;
    @ApiModelProperty("加盟门店付款信息（需要处理空格）")
    private String storePaymentBankAccount;
    @ApiModelProperty("预留手机号")
    private String reservePhone;
    @ApiModelProperty("实际营运点交日期")
    private LocalDateTime actualPointDeliveryDate;
}
