package com.elitesland.cbpl.mdm.rpc.resp;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * Created by lance on 2023/8/4.
 */
@Data
@ApiModel(description = "组织树单条记录详细RPC信息")
public class TsOrgTreeDetailRpcVO {

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("组织树id")
    private Long id;

    /**
     * 组织树类型
     */
    @ApiModelProperty(value = "组织树类型")
    private String buTreeType;

    /**
     * 组织树状态
     */
    @ApiModelProperty(value = "组织树状态")
    @SysCode(sys = "yst-supp", mod = "BUTREE_STATUS")
    private String buTreeStatus;
    private String buTreeStatusName;

    /**
     * 组织树编号
     */
    @ApiModelProperty(value = "组织树编号")
    private String buTreeCode;

    /**
     * 组织树名称
     */
    @ApiModelProperty(value = "组织树名称")
    private String buTreeName;

    /**
     * 组织树版本
     */
    @ApiModelProperty(value = "组织树版本")
    private String buTreeVersion;

    /**
     * 组织树当前版本
     */
    @ApiModelProperty(value = "组织树当前版本")
    private String nowVersion;

    /**
     * 版本说明
     */
    @ApiModelProperty(value = "版本说明")
    private String versionInstruction;


    /**
     * 组织树明细树形结构
     */
    @ApiModelProperty(value = "组织树明细树形结构")
    private List<TsOrgTreeDRpcDTO> orgBuTreeDVOList;



}
