package com.elitescloud.cloudt.tims.sso.common;

/**
 * 常量类.
 *
 * @author Kaiser（wang shao）
 * @date 2023/7/26
 */
public class TimsSsoConstant {
    private TimsSsoConstant() {
    }

    /**
     * 成功的状态码
     */
    public static final int CODE_SUCCESS = 200;
    /**
     * 无权限
     */
    public static final int CODE_NO_PERMISSION = 403;
    /**
     * 账号已存在
     */
    public static final int CODE_USER_EXISTS = 422;
    /**
     * 手机号已存在
     */
    public static final int CODE_MOBILE_EXISTS = 422;
    /**
     * 手机号已存在
     */
    public static final int CODE_USER_NO_EXIST = 404;
    /**
     * 账号或密码错误
     */
    public static final int CODE_LOGIN_PWD_ERROR = 401;

    /**
     * 网关的token
     */
    public static final String GATEWAY_HEADER_AUTHORIZATION = "TimsGateWayAuthorization";

    /**
     * token中的appId
     */
    public static final String CLAIM_APP_ID = "TimsGateWayAppId";

    /**
     * 账号类型：总部员工
     */
    public static final String USER_TYPE_HEADQUARTERS = "1";

    /**
     * 账号类型：加盟商员工
     */
    public static final String USER_TYPE_PARTNER = "6";

    /**
     * 创建账号
     */
    public static final String URI_USER_ADD = "/open/user";
    /**
     * 登录token
     */
    public static final String URI_USER_TOKEN_LOGIN = "/open/authentication/login";
    /**
     * token续期
     */
    public static final String URI_USER_TOKEN_RENEW = "/open/user/tokenRenew";
    /**
     * 重置密码
     */
    public static final String URI_USER_PASSWORD_RESET = "/open/user/resetPw";

    /**
     * token类型
     */
    public static final String TOKEN_TYPE = "Bearer";
}
