package com.elitescloud.cloudt.tims.sso.params;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * Sso用户账号.
 *
 * @author Kaiser（wang shao）
 * @date 2023/7/26
 */
@Data
public class TimsSsoUserDTO implements Serializable {
    private static final long serialVersionUID = -3187260694768283274L;

    /**
     * 账号类型
     * <p>
     * userType 1总部账号 6加盟商账号
     */
    @NotBlank(message = "账号类型为空")
    private String userType;

    /**
     * 手机号
     * <p>
     * 加盟商账号必填
     */
    private String phonenumber;

    /**
     * 用户名
     * <p>
     * 加盟商账号必填
     */
    private String username;

    /**
     * 员工号
     * <p>
     * 总部员工账号必填
     */
    private String employeeCode;

    /**
     * 品牌编号
     * <p>
     * 必填
     */
    private String brandCode;

    /**
     * 密码
     * <p>
     * 必填
     */
    private String password;

    /**
     * 邮箱
     * <p>
     * 加盟商必填
     */
    private String email;
}
